/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.task;

import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.AlreadyBusyException;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.managed.HwmcaParentObject;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.Status;
import com.ibm.hwmca.fw.managed.Task;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.report.Report;
import com.ibm.hwmca.fw.settings.user.ConfirmationSettings;
import com.ibm.hwmca.fw.settings.user.ObjectLockingSettings;
import com.ibm.hwmca.fw.task.HwmcaPanelTaskletData;
import com.ibm.hwmca.fw.task.TaskBean;
import com.ibm.hwmca.fw.task.TaskErrorIds;
import com.ibm.hwmca.fw.task.TaskInstance;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.tasklet.xport.TaskletControlException;
import com.ibm.hwmca.fw.tasklet.xport.TaskletController;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LauncherTasklet
extends PanelTasklet
implements TaskErrorIds {
    private static final String TRACE_MASKT = "XFRMLTKT";
    private static final String TRACE_MASKF = "XFRMLTKF";
    private static final String TRACE_MASKD = "XFRMLTKD";
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.fw.task.res.TaskRes";
    private static final String SINGLE_TARGET_PANEL = "ObjectSelectionPanel";
    private static final String MISSING_TARGET_PANEL = "MissingTargetPanel";
    private static final String TARGET_PROMPT_PANEL = "TargetPromptPanel";
    private static final String INVALID_TARGET_PANEL = "InvalidStatusObjectListPanel";
    private static final String SINGLE_CONFIRMATION_PANEL = "TaskConfirmationPanel";
    private static final String MULTI_CONFIRMATION_PANEL = "TaskMultiConfirmationPanel";
    private static final String SECONDARY_WARNING_PANEL = "SecondaryObjectWarningForDisruptiveTaskPanel";
    private static int STATE_INITIAL = 0;
    private static int STATE_REMOTE_CHECK = 10;
    private static int STATE_MISSING_TARGET_CHECK = 20;
    private static int STATE_MISSING_TARGET_RESPONSE = 30;
    private static int STATE_TARGET_PROMPT_CHECK = 35;
    private static int STATE_TARGET_PROMPT_RESPONSE = 36;
    private static int STATE_SINGLETARGET_CHECK = 40;
    private static int STATE_SINGLETARGET_RESPONSE = 50;
    private static int STATE_CHECK_TARGETS = 60;
    private static int STATE_CHECK_TARGETS_RESPONSE = 70;
    private static int STATE_SECONDARY_CHECK = 80;
    private static int STATE_SECONDARY_RESPONSE = 90;
    private static int STATE_CONFIRMATION = 100;
    private static int STATE_CONFIRMATION_RESPONSE = 110;
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "LaunchTsklet");
    private String realTaskletName = null;
    private Long taskId = null;
    private Map initialData = null;
    private ManagedObjectManager mom = null;
    private Task task = null;
    private HwmcaObject[] targets = null;
    private ManagedObject[] busyTargets = null;
    private ObjectId[] lockTargetIds = null;
    private int state = STATE_INITIAL;
    private boolean postedRequest = false;
    private boolean terminateValue = true;
    private Object taskData = null;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$HwmcaParentObject;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$HwmcaObject;

    public LauncherTasklet() {
        Trace.trace(TRACE_MASKT, "<> LauncherTasklet ctor");
    }

    public void service(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> LauncherTasklet.service()");
        try {
            this.postedRequest = false;
            this.terminateValue = true;
            Trace.trace(TRACE_MASKF, "state is: " + this.state);
            TaskInstance.getTaskInstance().set(this.taskData);
            if (taskletRequest.isInitialRequest()) {
                Trace.trace(TRACE_MASKF, "it is the initial request");
                TaskInstance.getTaskInstance().set(this);
                this.handleInitial(taskletRequest, taskletResponse);
                TaskInstance.getTaskInstance().set(this.taskData);
            }
            if (!taskletRequest.isDisposed() && !taskletRequest.isCanceled()) {
                Trace.trace(TRACE_MASKF, "state now is: " + this.state);
                if (!this.postedRequest && this.state == STATE_MISSING_TARGET_RESPONSE) {
                    Trace.trace(TRACE_MASKF, "handling missing target response");
                    this.handleMissingTargetResponse(taskletRequest, taskletResponse);
                }
                if (!this.postedRequest && this.state == STATE_TARGET_PROMPT_CHECK) {
                    Trace.trace(TRACE_MASKF, "handling target prompt checking");
                    this.handleTargetPromptCheck(taskletRequest, taskletResponse);
                }
                if (!this.postedRequest && this.state == STATE_TARGET_PROMPT_RESPONSE) {
                    Trace.trace(TRACE_MASKF, "handling target prompt response");
                    this.handleTargetPromptResponse(taskletRequest, taskletResponse);
                }
                if (!this.postedRequest && this.state == STATE_SINGLETARGET_CHECK) {
                    Trace.trace(TRACE_MASKF, "handling single target checking");
                    this.handleSingleTargetCheck(taskletRequest, taskletResponse);
                }
                if (!this.postedRequest && this.state == STATE_SINGLETARGET_RESPONSE) {
                    Trace.trace(TRACE_MASKF, "handling single target response");
                    this.handleSingleTargetResponse(taskletRequest, taskletResponse);
                }
                if (!this.postedRequest && this.state == STATE_CHECK_TARGETS) {
                    Trace.trace(TRACE_MASKF, "handling target checking");
                    this.handleCheckTargets(taskletRequest, taskletResponse);
                }
                if (!this.postedRequest && this.state == STATE_CHECK_TARGETS_RESPONSE) {
                    Trace.trace(TRACE_MASKF, "handling check targets response");
                    this.handleCheckTargetsResponse(taskletRequest, taskletResponse);
                }
                if (!this.postedRequest && this.state == STATE_SECONDARY_CHECK) {
                    Trace.trace(TRACE_MASKF, "handling secondary target checking");
                    this.handleSecondaryTargetCheck(taskletRequest, taskletResponse);
                }
                if (!this.postedRequest && this.state == STATE_SECONDARY_RESPONSE) {
                    Trace.trace(TRACE_MASKF, "handling secondary targets check response");
                    this.handleSecondaryTargetResponse(taskletRequest, taskletResponse);
                }
                if (!this.postedRequest && this.state == STATE_CONFIRMATION) {
                    Trace.trace(TRACE_MASKF, "handling confirmation checking");
                    this.handleConfirmation(taskletRequest, taskletResponse);
                }
                if (!this.postedRequest && this.state == STATE_CONFIRMATION_RESPONSE) {
                    Trace.trace(TRACE_MASKF, "handling confirmation response");
                    this.handleConfirmationResponse(taskletRequest, taskletResponse);
                }
            } else {
                this.terminateValue = false;
            }
            this.taskData = TaskInstance.getTaskInstance().get();
            if (!this.postedRequest) {
                if (this.terminateValue) {
                    Trace.trace(TRACE_MASKF, "updating console tasks performed information");
                    this.task.updateTasksPerformed(this.presentationTaskParms);
                    if (this.targets != null && this.task.updateTargetsLastTaskName()) {
                        for (int i = 0; i < this.targets.length; ++i) {
                            try {
                                if (this.targets[i] == null || !(this.targets[i] instanceof ManagedObject)) continue;
                                ((ManagedObject)this.targets[i]).setLastTaskName(this.task.getUIInfo().getUnlocalizedName());
                                continue;
                            }
                            catch (Exception e) {
                                Trace.trace(TRACE_MASKF, "Exception trying to set the last task name for a target object");
                                Trace.trace(TRACE_MASKF, e);
                            }
                        }
                    }
                }
                if (this.realTaskletName != null && this.terminateValue) {
                    Trace.trace(TRACE_MASKF, "request not posted; trying to redirect");
                    HwmcaParentObject[] groups = (HwmcaParentObject[])HwmcaParentObject.getObjectsFromIds(this.presentationTaskParms.getGroupIds(), class$com$ibm$hwmca$fw$managed$HwmcaParentObject == null ? (class$com$ibm$hwmca$fw$managed$HwmcaParentObject = LauncherTasklet.class$("com.ibm.hwmca.fw.managed.HwmcaParentObject")) : class$com$ibm$hwmca$fw$managed$HwmcaParentObject);
                    HwmcaPanelTaskletData redirectData = new HwmcaPanelTaskletData(this.task, this.targets, groups, this);
                    taskletResponse.redirect(this.realTaskletName, redirectData, this.presentationTaskParms, this.initialData, true);
                } else {
                    Trace.trace(TRACE_MASKF, "request not posted; terminating");
                    taskletResponse.terminate(this.terminateValue);
                    this.unbusyTargets();
                }
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception during service: " + e);
            this.unbusyTargets();
            if (e instanceof TaskletException) {
                throw (TaskletException)e;
            }
            throw new TaskletException(e);
        }
        Trace.trace(TRACE_MASKT, "<- LauncherTasklet.service()");
    }

    private void unbusyTargets() {
        if (this.busyTargets != null && this.busyTargets.length > 0) {
            for (int i = 0; i < this.busyTargets.length; ++i) {
                if (this.busyTargets[i] == null) continue;
                try {
                    this.busyTargets[i].setBusy(false);
                }
                catch (AlreadyBusyException alreadyBusyException) {
                    // empty catch block
                }
                this.busyTargets[i] = null;
            }
        }
    }

    void unbusyTarget(ObjectId id) {
        if (this.busyTargets != null && this.busyTargets.length > 0) {
            for (int i = 0; i < this.busyTargets.length; ++i) {
                if (this.busyTargets[i] == null || !id.equals(this.busyTargets[i].getObjectId())) continue;
                try {
                    this.busyTargets[i].setBusy(false);
                }
                catch (AlreadyBusyException alreadyBusyException) {
                    // empty catch block
                }
                this.busyTargets[i] = null;
            }
        }
    }

    private void lockTargets() {
        Trace.trace(TRACE_MASKD, "-> LauncherTasklet.lockTargets()");
        ObjectLockingSettings settings = ObjectLockingSettings.getObjectLockingSettings();
        if (settings.getRelock() && this.task.isRelockAllowed()) {
            Trace.trace(TRACE_MASKD, "   lockTargetIds is " + this.lockTargetIds);
            if (this.lockTargetIds != null && this.lockTargetIds.length > 0) {
                for (int i = 0; i < this.lockTargetIds.length; ++i) {
                    if (this.lockTargetIds[i] == null) continue;
                    this.mom.setProperty(this.lockTargetIds[i], "Locked", Boolean.TRUE);
                }
            }
        } else {
            Trace.trace(TRACE_MASKD, "   relock is false or relock is not allowed by the task");
        }
        Trace.trace(TRACE_MASKD, "<- LauncherTasklet.lockTargets()");
    }

    private void handleInitial(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> LauncherTasklet.handleInitial()");
        this.realTaskletName = (String)taskletRequest.getData("REAL_TASKLET");
        try {
            if (this.realTaskletName != null) {
                TaskletController.checkPermission(this.realTaskletName);
            }
            this.taskId = (Long)taskletRequest.getData("TASK_ID");
            this.initialData = taskletRequest.getDataMap();
            if (this.initialData != null) {
                this.initialData.remove("REAL_TASKLET");
                this.initialData.remove("TASK_ID");
            }
            Trace.trace(TRACE_MASKF, "real tasklet name is: [" + this.realTaskletName + "]");
            Trace.trace(TRACE_MASKF, "non-Panel task id: [" + this.taskId + "]");
            this.mom = ManagedObjectManager.getManagedObjectManager();
            this.task = (Task)this.mom.get(this.presentationTaskParms.getTaskId());
            ObjectId[] targetIds = this.presentationTaskParms.getTargetIds();
            this.lockTargetIds = targetIds;
            targetIds = this.task.updateInitialTargets(targetIds);
            if (targetIds != this.presentationTaskParms.getTargetIds()) {
                this.presentationTaskParms.setTargetIds(targetIds);
                if (!this.task.isAnyPermitted()) {
                    this.presentationTaskParms.trimTargetIds(this.task.getPermittedObjects());
                }
            }
            this.targets = ManagedObject.getObjectsFromIds(targetIds, class$com$ibm$hwmca$fw$managed$HwmcaObject == null ? (class$com$ibm$hwmca$fw$managed$HwmcaObject = LauncherTasklet.class$("com.ibm.hwmca.fw.managed.HwmcaObject")) : class$com$ibm$hwmca$fw$managed$HwmcaObject);
            int missingTargetCount = 0;
            if (this.targets != null) {
                for (int i = 0; i < this.targets.length; ++i) {
                    if (this.targets[i] != null) continue;
                    ++missingTargetCount;
                    Trace.trace(TRACE_MASKF, "Target object no longer valid; id=" + this.presentationTaskParms.getTargetIds()[i]);
                }
            }
            if (missingTargetCount != 0) {
                int j = 0;
                HwmcaObject[] tmptargets = new HwmcaObject[this.targets.length - missingTargetCount];
                for (int i = 0; i < this.targets.length; ++i) {
                    if (this.targets[i] == null) continue;
                    tmptargets[j] = this.targets[i];
                    ++j;
                }
                this.targets = tmptargets;
                ObjectId[] newIds = new ObjectId[this.targets.length];
                for (int i = 0; i < this.targets.length; ++i) {
                    newIds[i] = this.targets[i].getObjectId();
                }
                this.presentationTaskParms.setTargetIds(newIds);
                if (!this.task.isAnyPermitted()) {
                    this.presentationTaskParms.trimTargetIds(this.task.getPermittedObjects());
                }
            }
            if (this.task != null) {
                this.state = STATE_REMOTE_CHECK;
                Trace.trace(TRACE_MASKF, "handling remote checking");
                boolean clientIsLocal = UserContext.getCurrentUserContext().isLocalContext();
                if (clientIsLocal || this.task.canExecuteRemotely() && !clientIsLocal) {
                    if (missingTargetCount == 0) {
                        this.state = STATE_TARGET_PROMPT_CHECK;
                        Trace.trace(TRACE_MASKF, "handling target prompt checking");
                        this.handleTargetPromptCheck(taskletRequest, taskletResponse);
                    } else {
                        this.state = STATE_MISSING_TARGET_CHECK;
                        this.handleMissingTargetCheck(taskletRequest, taskletResponse);
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "telling the user that the task cannot be executed remotely");
                    MessageText[] msgs = new BaseMessageText[]{new BaseMessageText("TSK0001")};
                    this.showMessageBox(true, new BaseMessageTitle("task.error.title"), msgs, msgs[0].getMsgId(), msgs[0].getMsgType(), null);
                    this.terminateValue = false;
                }
            } else {
                Trace.trace(TRACE_MASKF, "telling the user that they are not authorized for the task");
                MessageText[] msgs = new BaseMessageText[]{new BaseMessageText("TSK0003")};
                this.showMessageBox(true, new BaseMessageTitle("task.error.title"), msgs, msgs[0].getMsgId(), msgs[0].getMsgType(), null);
                this.terminateValue = false;
            }
        }
        catch (TaskletControlException e) {
            Trace.trace(TRACE_MASKF, "telling the user that they are not authorized for the tasklet");
            MessageText[] msgs = new BaseMessageText[]{new BaseMessageText("TSK0003")};
            this.showMessageBox(true, new BaseMessageTitle("task.error.title"), msgs, msgs[0].getMsgId(), msgs[0].getMsgType(), null);
            this.terminateValue = false;
        }
        Trace.trace(TRACE_MASKT, "<- LauncherTasklet.handleInitial()");
    }

    private void handleMissingTargetCheck(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> LauncherTasklet.handleMissingTargetCheck()");
        if (this.targets.length > 0) {
            this.postedRequest = true;
            TaskBean bean = new TaskBean();
            Report[] targetInfo = new Report[this.targets.length];
            for (int i = 0; i < this.targets.length; ++i) {
                targetInfo[i] = new Report(this.targets[i].getObjectId(), this.targets[i].getUIInfo().getUnlocalizedName());
            }
            bean.initMissingTargetPanel(this.task.getUIInfo().getUnlocalizedName(), targetInfo, this.taskId, this.presentationTaskParms, this.task.getPermittedObjects());
            taskletResponse.replace(AUIML_FILE_NAME, MISSING_TARGET_PANEL, bean);
            this.state = STATE_MISSING_TARGET_RESPONSE;
        } else {
            Trace.trace(TRACE_MASKF, "No valid targets left; telling the user.");
            MessageText[] msgs = new BaseMessageText[]{new BaseMessageText("TSK0008")};
            this.showMessageBox(true, new BaseMessageTitle("task.error.title"), msgs, msgs[0].getMsgId(), msgs[0].getMsgType(), null);
            this.terminateValue = false;
        }
        Trace.trace(TRACE_MASKT, "<- LauncherTasklet.handleMissingTargetCheck()");
    }

    private void handleMissingTargetResponse(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> LauncherTasklet.handleMissingTargetResponse()");
        Boolean keepGoing = (Boolean)taskletRequest.getData("TASKLET_DATA");
        if (keepGoing != null && keepGoing.booleanValue()) {
            this.state = STATE_SINGLETARGET_CHECK;
        } else {
            this.terminateValue = false;
        }
        Trace.trace(TRACE_MASKT, "<- LauncherTasklet.handleMissingTargetResponse()");
    }

    private void handleTargetPromptCheck(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> LauncherTasklet.handleTargetPromptCheck()");
        if (this.targets == null || this.targets.length == 0) {
            if (this.task.promptForTargets()) {
                Set taskClassNames = this.task.getPermittedObjects();
                ArrayList potentials = new ArrayList();
                Iterator i = taskClassNames.iterator();
                while (i.hasNext()) {
                    ClassId clsId = new ClassId((String)i.next());
                    try {
                        if (!clsId.isInstanceOf("com.ibm.hwmca.fw.managed.ManagedObject")) continue;
                        Trace.trace(TRACE_MASKF, "getting potential targets of class: " + clsId);
                        Set inv = this.mom.getInventoryObjectIds(clsId);
                        Iterator j = inv.iterator();
                        while (j.hasNext()) {
                            potentials.add(j.next());
                        }
                    }
                    catch (HException e) {
                        Trace.trace(TRACE_MASKF, "skipping HException from isInstanceOf for: " + clsId);
                    }
                }
                if (potentials.size() > 0) {
                    Report[] targetInfo = new Report[potentials.size()];
                    for (int i2 = 0; i2 < targetInfo.length; ++i2) {
                        ObjectId id = (ObjectId)potentials.get(i2);
                        LocalizableText lt = this.task.getPromptTextForTarget(id);
                        if (lt == null) {
                            UIInfo uiInfo = (UIInfo)this.mom.getProperty(id, "UIInfo");
                            lt = uiInfo.getUnlocalizedName();
                        }
                        targetInfo[i2] = new Report(id, lt);
                        Trace.trace(TRACE_MASKF, "adding potential targets of: " + id);
                    }
                    this.postedRequest = true;
                    TaskBean bean = new TaskBean();
                    bean.initTargetPromptPanel(this.task.getUIInfo().getUnlocalizedName(), targetInfo, this.taskId, this.presentationTaskParms, this.task.getPermittedObjects());
                    taskletResponse.replace(AUIML_FILE_NAME, TARGET_PROMPT_PANEL, bean);
                    this.state = STATE_TARGET_PROMPT_RESPONSE;
                } else {
                    Trace.trace(TRACE_MASKF, "No valid targets; telling the user.");
                    MessageText[] msgs = new BaseMessageText[]{new BaseMessageText("TSK0009")};
                    this.showMessageBox(true, new BaseMessageTitle("task.error.title"), msgs, msgs[0].getMsgId(), msgs[0].getMsgType(), null);
                    this.terminateValue = false;
                }
            } else if (this.task.isTargetRequired()) {
                Trace.trace(TRACE_MASKF, "No valid targets; telling the user.");
                MessageText[] msgs = new BaseMessageText[]{new BaseMessageText("TSK0009")};
                this.showMessageBox(true, new BaseMessageTitle("task.error.title"), msgs, msgs[0].getMsgId(), msgs[0].getMsgType(), null);
                this.terminateValue = false;
            } else {
                this.state = STATE_SINGLETARGET_CHECK;
                Trace.trace(TRACE_MASKF, "handling single target checking - no targets");
                this.handleSingleTargetCheck(taskletRequest, taskletResponse);
            }
        } else {
            this.state = STATE_SINGLETARGET_CHECK;
            Trace.trace(TRACE_MASKF, "handling single target checking - with targets");
            this.handleSingleTargetCheck(taskletRequest, taskletResponse);
        }
        Trace.trace(TRACE_MASKT, "<- LauncherTasklet.handleTargetPromptCheck()");
    }

    private void handleTargetPromptResponse(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> LauncherTasklet.handleTargetPromptResponse()");
        ObjectId[] selectedIds = (ObjectId[])taskletRequest.getData("TASKLET_DATA");
        if (selectedIds != null) {
            if (selectedIds.length > 0) {
                ArrayList<HwmcaObject> targetArray = new ArrayList<HwmcaObject>();
                for (int i = 0; i < selectedIds.length; ++i) {
                    HwmcaObject obj;
                    if (selectedIds[i] == null || (obj = this.mom.get(selectedIds[i])) == null) continue;
                    targetArray.add(obj);
                }
                if (targetArray.size() > 0) {
                    ObjectId[] targetIds = new ObjectId[targetArray.size()];
                    this.targets = new HwmcaObject[targetIds.length];
                    for (int i = 0; i < this.targets.length; ++i) {
                        this.targets[i] = (HwmcaObject)targetArray.get(i);
                        targetIds[i] = this.targets[i].getObjectId();
                    }
                    this.presentationTaskParms.setTargetIds(targetIds);
                    if (!this.task.isAnyPermitted()) {
                        this.presentationTaskParms.trimTargetIds(this.task.getPermittedObjects());
                    }
                    this.state = STATE_SINGLETARGET_CHECK;
                } else {
                    Trace.trace(TRACE_MASKF, "No valid targets left; telling the user.");
                    MessageText[] msgs = new BaseMessageText[]{new BaseMessageText("TSK0008")};
                    this.showMessageBox(true, new BaseMessageTitle("task.error.title"), msgs, msgs[0].getMsgId(), msgs[0].getMsgType(), null);
                    this.terminateValue = false;
                }
            } else {
                Trace.trace(TRACE_MASKF, "No targets selected; telling the user.");
                MessageText[] msgs = new BaseMessageText[]{new BaseMessageText("TSK0010")};
                this.showMessageBox(true, new BaseMessageTitle("task.error.title"), msgs, msgs[0].getMsgId(), msgs[0].getMsgType(), null);
                this.postedRequest = true;
                taskletResponse.noAction();
            }
        } else {
            this.terminateValue = false;
        }
        Trace.trace(TRACE_MASKT, "<- LauncherTasklet.handleTargetPromptResponse()");
    }

    private void handleSingleTargetCheck(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> LauncherTasklet.handleSingleTargetCheck()");
        if (this.targets != null && this.targets.length > 1 && this.task.isSingleTarget()) {
            this.postedRequest = true;
            TaskBean bean = new TaskBean();
            Report[] targetInfo = new Report[this.targets.length];
            for (int i = 0; i < this.targets.length; ++i) {
                targetInfo[i] = new Report(this.targets[i].getObjectId(), this.targets[i].getUIInfo().getUnlocalizedName());
            }
            bean.initSingleObjectSelection(this.task.getUIInfo().getUnlocalizedName(), targetInfo, this.taskId, this.presentationTaskParms, this.task.getPermittedObjects());
            taskletResponse.replace(AUIML_FILE_NAME, SINGLE_TARGET_PANEL, bean);
            this.state = STATE_SINGLETARGET_RESPONSE;
        } else {
            this.state = STATE_CHECK_TARGETS;
        }
        Trace.trace(TRACE_MASKT, "<- LauncherTasklet.handleSingleTargetCheck()");
    }

    private void handleSingleTargetResponse(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> LauncherTasklet.handleSingleTargetResponse()");
        ObjectId singleTargetId = (ObjectId)taskletRequest.getData("TASKLET_DATA");
        if (singleTargetId != null) {
            HwmcaObject singleTarget = null;
            for (int i = 0; i < this.targets.length && singleTarget == null; ++i) {
                if (!this.targets[i].getObjectId().equals(singleTargetId)) continue;
                singleTarget = this.targets[i];
            }
            this.targets = new HwmcaObject[]{singleTarget};
            this.presentationTaskParms.setTargetIds(new ObjectId[]{singleTarget.getObjectId()});
            if (!this.task.isAnyPermitted()) {
                this.presentationTaskParms.trimTargetIds(this.task.getPermittedObjects());
            }
            this.state = STATE_CHECK_TARGETS;
        } else {
            this.terminateValue = false;
        }
        Trace.trace(TRACE_MASKT, "<- LauncherTasklet.handleSingleTargetResponse()");
    }

    private void handleCheckTargets(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> LauncherTasklet.handleCheckTargets()");
        if (this.targets != null && this.targets.length > 0) {
            Object validText = null;
            BaseMessageTitle busyText = new BaseMessageTitle("task.target.busy");
            BaseMessageTitle notAllowedText = new BaseMessageTitle("task.target.notpermitted");
            BaseMessageTitle noCommText = new BaseMessageTitle("task.target.nocommunications");
            BaseMessageTitle lockedText = new BaseMessageTitle("task.target.locked");
            LocalizableText[][] results = new LocalizableText[this.targets.length][];
            this.busyTargets = new ManagedObject[this.targets.length];
            for (int i = 0; i < this.targets.length; ++i) {
                String targetId;
                boolean isLocked = false;
                if (this.targets[i] instanceof ManagedObject) {
                    isLocked = ((ManagedObject)this.targets[i]).isLocked();
                    targetId = ((ManagedObject)this.targets[i]).getTargetId();
                } else {
                    targetId = this.targets[i].getClass().getName();
                }
                results[i] = new LocalizableText[2];
                results[i][0] = this.targets[i].getUIInfo().getUnlocalizedName();
                Trace.trace(TRACE_MASKD, "setting result name for: [" + this.targets[i].getObjectId() + " to [" + results[i][0] + "]");
                boolean isBusy = false;
                if (!this.task.acceptsBusyTargets()) {
                    if (this.task.busyTargets() && this.realTaskletName != null && this.targets[i] instanceof ManagedObject) {
                        try {
                            ((ManagedObject)this.targets[i]).setBusy(true);
                            this.busyTargets[i] = (ManagedObject)this.targets[i];
                        }
                        catch (AlreadyBusyException e) {
                            isBusy = true;
                        }
                    } else if (this.targets[i] instanceof ManagedObject) {
                        isBusy = ((ManagedObject)this.targets[i]).isBusy();
                    }
                }
                if (isBusy) {
                    Trace.trace(TRACE_MASKD, "we think the target is busy");
                    results[i][1] = busyText;
                    continue;
                }
                if (!this.task.isObjectPermitted(targetId)) {
                    Trace.trace(TRACE_MASKD, "we think the target is not permitted");
                    results[i][1] = notAllowedText;
                    continue;
                }
                if (this.task.isRequireCommunications() && this.targets[i] instanceof ManagedObject && Status.NOT_COMMUNICATING.equals(((ManagedObject)this.targets[i]).getStatus())) {
                    Trace.trace(TRACE_MASKD, "we think the target is not communicating");
                    results[i][1] = noCommText;
                    continue;
                }
                if (isLocked && this.task.isDisruptive()) {
                    Trace.trace(TRACE_MASKD, "we think the target is locked");
                    results[i][1] = lockedText;
                    continue;
                }
                Trace.trace(TRACE_MASKD, "we think the target is ok");
                results[i][1] = validText;
            }
            List taskResults = this.task.checkTargets(this.presentationTaskParms);
            if (taskResults != null) {
                for (int i = 0; i < taskResults.size(); ++i) {
                    Report rpt;
                    try {
                        rpt = (Report)taskResults.get(i);
                    }
                    catch (ClassCastException e) {
                        rpt = null;
                    }
                    if (rpt == null) continue;
                    for (int j = 0; j < this.targets.length; ++j) {
                        if (!this.targets[j].getObjectId().equals(rpt.getObjectId()) || results[j][1] != validText) continue;
                        results[j][1] = rpt.getText();
                        Trace.trace(TRACE_MASKD, "task thinks there is something wrong with [" + this.targets[j].getObjectId() + "]");
                        if (results[j][1] != null) continue;
                        results[j][1] = validText;
                    }
                }
            }
            boolean allTargetsOk = true;
            ArrayList<HwmcaObject> goodTargets = new ArrayList<HwmcaObject>();
            for (int i = 0; i < results.length; ++i) {
                if (results[i][1] == validText) {
                    Trace.trace(TRACE_MASKD, "target [" + this.targets[i].getObjectId() + "] is ok");
                    goodTargets.add(this.targets[i]);
                    continue;
                }
                Trace.trace(TRACE_MASKD, "target [" + this.targets[i].getObjectId() + "] is NOT ok");
                allTargetsOk = false;
            }
            if (allTargetsOk) {
                this.state = STATE_SECONDARY_CHECK;
            } else {
                int i;
                this.targets = new HwmcaObject[goodTargets.size()];
                ObjectId[] targetIds = new ObjectId[goodTargets.size()];
                for (i = 0; i < this.targets.length; ++i) {
                    this.targets[i] = (HwmcaObject)goodTargets.get(i);
                    targetIds[i] = this.targets[i].getObjectId();
                }
                this.presentationTaskParms.setTargetIds(targetIds);
                if (!this.task.isAnyPermitted()) {
                    this.presentationTaskParms.trimTargetIds(this.task.getPermittedObjects());
                }
                if (this.busyTargets != null && this.busyTargets.length > 0) {
                    for (i = 0; i < this.busyTargets.length; ++i) {
                        if (this.busyTargets[i] == null) continue;
                        boolean validTarget = false;
                        for (int j = 0; j < this.targets.length && !validTarget; ++j) {
                            if (!this.targets[j].getObjectId().equals(this.busyTargets[i].getObjectId())) continue;
                            validTarget = true;
                        }
                        if (validTarget) continue;
                        try {
                            this.busyTargets[i].setBusy(false);
                        }
                        catch (AlreadyBusyException e) {
                            // empty catch block
                        }
                        this.busyTargets[i] = null;
                    }
                }
                this.postedRequest = true;
                TaskBean bean = new TaskBean();
                bean.initInvalidTargetDisplay(this.task.getUIInfo().getUnlocalizedName(), results, this.targets.length == 0, this.taskId, this.presentationTaskParms, this.task.getPermittedObjects());
                taskletResponse.replace(AUIML_FILE_NAME, INVALID_TARGET_PANEL, bean);
                this.state = STATE_CHECK_TARGETS_RESPONSE;
            }
        } else {
            this.state = STATE_SECONDARY_CHECK;
        }
        Trace.trace(TRACE_MASKT, "<- LauncherTasklet.handleCheckTargets()");
    }

    private void handleCheckTargetsResponse(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> LauncherTasklet.handleCheckTargetsResponse()");
        Boolean keepGoing = (Boolean)taskletRequest.getData("TASKLET_DATA");
        if (keepGoing != null && keepGoing.booleanValue()) {
            this.state = STATE_SECONDARY_CHECK;
        } else {
            this.terminateValue = false;
        }
        Trace.trace(TRACE_MASKT, "<- LauncherTasklet.handleCheckTargetsResponse()");
    }

    private void handleSecondaryTargetCheck(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> LauncherTasklet.handleSecondaryTargetCheck()");
        if (this.task.isDisruptive()) {
            ManagedObject[] secondaryTargets = this.task.checkSecondaryTargets(this.presentationTaskParms);
            if (secondaryTargets != null) {
                LocalizableText[][] results = new LocalizableText[secondaryTargets.length][];
                for (int i = 0; i < secondaryTargets.length; ++i) {
                    results[i] = new LocalizableText[2];
                    results[i][0] = secondaryTargets[i].getUIInfo().getUnlocalizedName();
                    results[i][1] = secondaryTargets[i].getStatus().getUIInfo().getUnlocalizedName();
                }
                this.postedRequest = true;
                TaskBean bean = new TaskBean();
                bean.initSecondaryTargetDisplay(this.task.getUIInfo().getUnlocalizedName(), results, this.taskId, this.presentationTaskParms, this.task.getPermittedObjects());
                taskletResponse.replace(AUIML_FILE_NAME, SECONDARY_WARNING_PANEL, bean);
                this.state = STATE_SECONDARY_RESPONSE;
            } else {
                this.state = STATE_CONFIRMATION;
            }
        } else {
            this.state = STATE_CONFIRMATION;
        }
        Trace.trace(TRACE_MASKT, "<- LauncherTasklet.handleSecondaryTargetCheck()");
    }

    private void handleSecondaryTargetResponse(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> LauncherTasklet.handleSecondaryTargetResponse()");
        Boolean keepGoing = (Boolean)taskletRequest.getData("TASKLET_DATA");
        if (keepGoing != null && keepGoing.booleanValue()) {
            this.state = STATE_CONFIRMATION;
        } else {
            this.terminateValue = false;
        }
        Trace.trace(TRACE_MASKT, "<- LauncherTasklet.handleSecondaryTargetResponse()");
    }

    private void handleConfirmation(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        LocalizableText[] confirmTexts;
        Trace.trace(TRACE_MASKT, "-> LauncherTasklet.handleConfirmation()");
        ManagedObject[] myTargets = null;
        if (this.targets != null) {
            ArrayList<HwmcaObject> confirmTargets = new ArrayList<HwmcaObject>();
            for (int i = 0; i < this.targets.length; ++i) {
                if (!(this.targets[i] instanceof ManagedObject)) continue;
                confirmTargets.add(this.targets[i]);
            }
            myTargets = confirmTargets.toArray(new ManagedObject[confirmTargets.size()]);
        }
        if (this.task.isConfirmationDesired(myTargets) && (confirmTexts = this.task.getConfirmationTexts(myTargets)) != null) {
            if (confirmTexts.length == myTargets.length) {
                boolean singleConfirmText = true;
                for (int i = 0; i < confirmTexts.length && singleConfirmText; ++i) {
                    singleConfirmText = confirmTexts[0].equals(confirmTexts[i]);
                }
                this.postedRequest = true;
                TaskBean bean = new TaskBean();
                LocalizableText[][] targetData = new LocalizableText[myTargets.length][];
                for (int i = 0; i < myTargets.length; ++i) {
                    targetData[i] = new LocalizableText[2];
                    targetData[i][0] = myTargets[i].getUIInfo().getUnlocalizedName();
                    if (singleConfirmText) continue;
                    targetData[i][1] = confirmTexts[i];
                }
                ConfirmationSettings cs = (ConfirmationSettings)User.getUser().getAllUserSettings().get("com.ibm.hwmca.fw.settings.user.ConfirmationSettings");
                bean.initConfirmationPanel(this.task.getUIInfo().getUnlocalizedName(), targetData, singleConfirmText ? confirmTexts[0] : null, this.taskId, this.presentationTaskParms, this.task.getPermittedObjects(), cs.showWithObjectList());
                if (singleConfirmText) {
                    taskletResponse.replace(AUIML_FILE_NAME, SINGLE_CONFIRMATION_PANEL, bean);
                } else {
                    taskletResponse.replace(AUIML_FILE_NAME, MULTI_CONFIRMATION_PANEL, bean);
                }
                this.state = STATE_CONFIRMATION_RESPONSE;
            } else {
                Trace.trace(TRACE_MASKF, "invalid number of confirmation text returned");
            }
        }
        Trace.trace(TRACE_MASKT, "<- LauncherTasklet.handleConfirmation()");
    }

    private void handleConfirmationResponse(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> LauncherTasklet.handleConfirmationResponse()");
        Boolean keepGoing = (Boolean)taskletRequest.getData("TASKLET_DATA");
        if (keepGoing == null || !keepGoing.booleanValue()) {
            this.terminateValue = false;
        }
        Trace.trace(TRACE_MASKT, "<- LauncherTasklet.handleConfirmationResponse()");
    }

    public void destroy() {
        Trace.trace(TRACE_MASKT, "-> LauncherTasklet.destroy()");
        this.unbusyTargets();
        this.lockTargets();
        Trace.trace(TRACE_MASKT, "<- LauncherTasklet.destroy()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> LauncherTasklet.logException()");
        Trace.trace(TRACE_MASKT, "processing exception: " + throwable);
        new FrameworkLog(classLogInfo, 56, throwable).log();
        Trace.trace(TRACE_MASKT, "<- LauncherTasklet.logException()");
    }

    Object getTaskData() {
        return this.taskData;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

